varying vec2 		texcoord;
varying vec2		VPOS;

uniform sampler2D 	depthTex;
uniform float 		density;
uniform vec3		waterColor;
uniform vec3		moonlightcolor;

// ------------ ATMOSPHERE ------------------------------

uniform float 		length_unit;
uniform vec3 		earth_center;
uniform vec3 		sundir;
uniform mat4		eyeToWorld;

vec3 GetSunIrradiance(vec3 p, vec3 sun_direction);

// -------------------------------------------------------

void main()
{
	vec4 pos;
	pos.z=texture2D(depthTex,texcoord.st).r;
	
	// compute eye position
	pos.xy=VPOS*-pos.z;
	pos.w=1.0;
	vec4 Wpos=eyeToWorld*pos;
	vec3 rwp=-earth_center.xyz;
	rwp.y=-earth_center.y+(100.0*length_unit);
	vec3 sunLightColor = GetSunIrradiance(rwp, sundir) + moonlightcolor;
	
	float dist=length(pos);
	float waterDensity=1.0-exp(-dist*density);//(clamp(pow(log(dist*density+1.0)*0.5,0.5),0.0,1.0));
	
	gl_FragColor.xyz=/*waterDensity**/waterColor.rgb*sunLightColor;
	gl_FragColor.w=waterDensity;
}
